#ifndef PSX_IDLE_HANDLER_HPP
#define PSX_IDLE_HANDLER_HPP

#include <atlbase.h>
#include <atlapp.h>
#include <atlwin.h>
#include "EFramework.hpp"
#include "PSXMachine.hpp"
#include "PSXProcessorDebugger.hpp"

namespace NeoPSX
{
	/// Handles idle time for the main window, when in windowed mode. Uses a basic FSM for state processing.
	class PSXIdleHandler : public CIdleHandler
	{
	public:
		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Public Enumerations

		/// Enumerates the idle handler modes.
		enum IdleModes
		{
			IM_NULL,
			IM_EMULATE
		};

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Constructors

		/** The default constructor. */
		PSXIdleHandler();

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Destructors
		
		/** The default destructor */
		~PSXIdleHandler();

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Idle State Functions

		/** Sets the mode for the idle handler FSM. */
		void   SetIdleMode(ushort newMode);
		/** Returns the mode for the idle handler FSM. */
		ushort GetIdleMode() const;

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Miscellaneous Functions

		/** Loads an executable file. */
		bool LoadExecutable(char* fileName);
		/** Displays the processor debug window. */
		void DisplayProcessorDebug();

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Overridden Function

		/** Handles idle message time. */
		BOOL OnIdle();
	private:
		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Private Variables

		USHORT                                mIdleMode; ///< The mode of the idle handler.
		PSXMachine                            mEmulator; ///< The Playstation machine emulator.
		std::auto_ptr< PSXProcessorDebugger > mDebugger; ///< The Playstation processor debug window.
	};
} // Namespace NeoPSX

#endif // PSX_IDLE_HANDLER_HPP